= Introduction =

User's instructions for the hclCheck tool.

Note: contents of this file is also in the README file distributed with the tool.

= Command Usage =

<pre>
$ ./hclCheck -h
usage: hclCheck [-h] [--hostname hostname [hostname ...]] [--username USERNAME]
               [--password PASSWORD] [--hcl-url HCL_URL]

Check ESXi host against VSAN HCL

optional arguments:
  -h, --help            show this help message and exit
  --hostname hostname [hostname ...]
                        Hostname/IP of ESXi host
  --username USERNAME   Username (default: root)
  --password PASSWORD   Password
  --hcl-url HCL\_URL     URL to VSAN HCL DB (http://path/to/hcl.db or
                        C:/path/to/hcl.db)
  --noSSLVerify         Skip SSL/HTTPS verification to ESXi hostd.
</pre>

Note: when supplying more than one hosts, ensure all hosts are accessible with the same username/password credential.

== Valid URLs to HCL ==

Default URL:
 http://partnerweb.vmware.com/service/vsan/all.json

Local filesystem (Windows):
 C:/path/to/all.json

Local filesystem (Linux):
 /home/user/path/to/all.json

Local filesystem (MacOS):
 /home/user/path/to/all.json

== Examples ==

=== Running command without supplying arguments ===

Run this command:
 hclCheck

Example output:

<pre>
Enter a valid URL for the HCL (leave blank for http://partnerweb.vmware.com/service/vsan/all.json):
Enter hostname [hostname ...]: w2-vsan-esx205.eng.vmware.com
Enter password for user root:
2022-08-09 19:16:29,071 - Downloading latest HCL DB ...
2022-08-09 19:16:30,416 - HCL current as of: 2022-08-09 19:16:30
2022-08-09 19:16:30,416 - Logging in to w2-vsan-esx205.eng.vmware.com as user 'root'
2022-08-09 19:16:30,835 - Fetching hardware information of host ...
2022-08-09 19:16:31,615 - Hostname: w2-vsan-esx205.eng.vmware.com
...
2022-08-09 19:16:31,624 - Wrote report to report\_1440641791.html
2022-08-09 19:16:31,624 - Please use a browser to view report output file report\_1440641791.html
</pre>

=== Checking two hosts ===

Run this command:

 hclCheck --hostname w2-vsan-esx205.eng.vmware.com w2-vsan-esx205.eng.vmware.com

Example output:
<pre>
Enter a valid URL for the HCL (leave blank for http://partnerweb.vmware.com/service/vsan/all.json):
2022-08-09 18:48:20,835 - Downloading latest HCL DB ...
2022-08-09 18:48:22,562 - HCL current as of: 2022-08-09 18:48:22
Enter password for user root:
2022-08-09 18:48:26,087 - Logging in to w2-vsan-esx205.eng.vmware.com as user 'root'
...
2022-08-09 18:48:28,683 - Please use a browser to view report output file report\_1440640108.html
Exitting program. Press ENTER to continue ...
</pre>

=== Provide path to HCL on the local filesystem ===

Download HCL from http://partnerweb.vmware.com/service/vsan/all.json

Run this command:
 hclCheck --hostname w2-vsan-esx205.eng.vmware.com --hcl-url /Users/sam/tmp/all.json

Example output:
<pre>
Enter password for user root:
2022-08-09 18:44:19,463 - Downloading latest HCL DB ...
2022-08-09 18:44:19,506 - HCL current as of: 2022-08-09 17:47:51
...
2022-08-09 18:44:22,526 - Wrote report to report\_1440639862.html
Exitting program. Press ENTER to continue ...
</pre>

= Viewing the report output report.html file =

* open report_{timestamp}.html with a browser
* The report shows HCL results for each host per tab
* The report shows if the controller is VMware ceritified
* The report shows if the ESXi release is VMware ceritified. If not, the report shows all supported ESXi release information.
* The report shows if the controller's driver is VMware certified, and shows all recommended driver versions.
* The report shows if the controller's firmware is VMware certified, and shows all recommended firmware versions.
* The report shows if it is vSAN ESA compatible when host version is 8.0
* The report shows if the pnic speed is over 25Gbps when host version is 8.0
* The report shows if the host memory is over 32 GB when host version is 8.0

= Requirements =

== Softwares Requirements ==

* Windows: 7, 8, 10, Server 2012, 2016
* CentOS 6, 7, 8
* Ubuntu 16, 18, 20
* RHEL 7, 8
* MacOS 11, 12, 13, 14, 15
* Browser: Chrome, Opera and Firefox

== Network Requirements ==

* HTTPS/443 access to ESXi hosts (interacting with hostd)
* Internet HTTP/80 access to http://partnerweb.vmware.com/service/vsan/all.json
* By default, ESXi's SSL certificate will be verified unless ran with the --noSSLVerify flag

== ESXi Host Requirements ==

* ESXi with version higher than 6.5u2 are supported
* Direct access to the hostd service with username and password

= Privacy Disclosure =

* We're not sending any data about the customer's environment over the network
* We are pulling the latest HCL data from  http://partnerweb.vmware.com/service/vsan/all.json
* Customer's data is used to generate report.html
